#include "SoundManager.h"

SoundManager :: SoundManager() {
   playing_menubackground = false;
   playing_ingamebackground = false;
   mute(false);
   maxvolume = 255;
}

SoundManager :: ~SoundManager() {
}

void SoundManager :: init() {

   if (FSOUND_GetVersion() < FMOD_VERSION) {
      printf("Error : You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
      exit(1);
   }
    
   if (!FSOUND_Init(44100, 32, 0)) {
      printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
      exit(1);
   }

   samples[SAM_FIRE] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/fire.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);
   samples[SAM_EXPLOSION] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/explodesm.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_JUMP] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/jump.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_DEATH] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/death.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_CHEERS] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/ms_cheer.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_BUZZER] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/ms_buzzer.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_BONUSCAPTURE] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/clipfall.wav", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);
   samples[SAM_METALLICA] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/sound/met3.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);

   for (int i=0;i<SAM_LAST;++i) {
      if (!samples[i]) {
         printf("FMOD ERROR: %s\n", FMOD_ErrorString(FSOUND_GetError()));
         exit(1);
      }
   }
   
}

void SoundManager :: destroy() {
   for (int i=0;i<SAM_LAST;++i)
      FSOUND_Sample_Free(samples[i]);

   FSOUND_Close();
}

void SoundManager :: update(float dt) {

   FadeSoundList::iterator i = fadeList.begin();
   while (i != fadeList.end()) {
      sFadeSound &fs = *i;
      if ((fs.signval > 0 && fs.f_vol < fs.targetvol) || (fs.signval < 0 && fs.f_vol > fs.targetvol)) {
         fs.f_vol += fs.signval * fs.speed * dt;
         FSOUND_SetVolume(fs.channel,fs.f_vol);
         ++i;
      }
      else {
         FadeSoundList::iterator crri = i;
         ++i;
         fadeList.erase(crri);
         FSOUND_StopSound(ingamebackground_channel);
      }
   }

}

void SoundManager :: setMasterVolume(unsigned char mvol) {
   FSOUND_SetSFXMasterVolume(mvol);
   maxvolume = mvol;
}

int SoundManager :: playSample(int sid,int channel,bool looped) {
   int m_channel = -1;
   if (mutesnd == false && (sid >= 0 && sid < SAM_LAST)) {
      m_channel = FSOUND_PlaySoundEx(channel,samples[sid],NULL,true);
      if (looped)
         FSOUND_SetLoopMode(m_channel,FSOUND_LOOP_NORMAL);
      FSOUND_SetPaused(m_channel,false);
   }
   setMasterVolume(maxvolume);
   return m_channel;
}

void SoundManager :: fadeSound(int channel,int fromvol,int tovol,float speed) {

   sFadeSound fs;
   fs.channel = channel;
   fs.targetvol = tovol;
   fs.speed = speed;
   fs.f_vol = fromvol;
   
   fs.signval = (tovol > fs.f_vol) ? 1 : -1;

   fadeList.push_back(fs);

}


void SoundManager :: playFireSound() {
   playSample(SAM_FIRE);
}

void SoundManager :: playExplosionSound() {
   playSample(SAM_EXPLOSION);
}

void SoundManager :: playDeathSound() {
   playSample(SAM_DEATH);
}

void SoundManager :: playCheersSound() {
   playSample(SAM_CHEERS);
}


void SoundManager :: playBuzzerSound() {
   playSample(SAM_BUZZER);
}

void SoundManager :: playBonusCaptureSound() {
   playSample(SAM_BONUSCAPTURE);
}

void SoundManager :: playMetallica() {
   playSample(SAM_METALLICA);
}

void SoundManager :: playJumpSound() {
   
/*
   static bool paused = false;
   static bool started = false;
   static int channel;
   
   if (enable) {
      if (!started) {
         if (!paused) {
            channel = playSample(SAM_MOVE,FSOUND_FREE,true);
            started = true;
         }
         else {
            FSOUND_SetPaused(channel,false);
            started = true;
         }
      }
   }
   else {
      if (started) { 
         FSOUND_SetPaused(channel,true);
         started = false;
         paused = true;
      }
   }

  */

   playSample(SAM_JUMP);
}

